/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QCoreApplication>
#include <QSettings>
#include <QDir>

#include "cSettings.h"

cSettings::cSettings()
{
    read_SettingsID();

    if (Settings_ID < 3)
    {
        QBitArray Def_TabViews;
        Def_TabViews.fill(true, 6);

        qDebug("Konvertiere Einstellungen Version 1+2 -> 3");
        QSettings Setting("KeyOz-Net", "QMK-Groundstation");

        Setting.beginGroup("GUI");
            GUI.TabViews    = Setting.value("TabViews", QBitArray(Def_TabViews)).value<QBitArray>();

            GUI.TabViews.resize(10);
            GUI.TabViews[6] = true;

            Setting.setValue("TabViews", QBitArray(GUI.TabViews));
        Setting.endGroup();
    }

    read_Settings();

    Analog1.LogView.resize(MaxAnalog);
    Analog1.PlotView.resize(MaxAnalog);

    // Alte Settingsstruktur Löschen.
    if (Settings_ID < 2)
    {
        qDebug("Konvertiere Einstellungen Version 1 -> 2");
        QSettings Setting("KeyOz-Net", "QMK-Groundstation");

        Setting.beginGroup("AnalogWerte");
            for (int a = 0; a < MaxAnalog; a++)
            {
                Analog1.LogView.setBit(a, Setting.value(("Analog_" + QString("%1").arg(a) + "_Log"),   Def_Log[a]).toBool());
                Analog1.PlotView.setBit(a, Setting.value(("Analog_" + QString("%1").arg(a) + "_Plot"),   Def_Plot_Show[a]).toBool());
                Analog1.Label[a] = Setting.value(("Analog_" + QString("%1").arg(a)), Def_AnalogNames[a]).toString();
            }
        Setting.endGroup();

        Setting.remove("AnalogWerte-FC");
        Setting.remove("AnalogWerte");

        write_Settings_Analog();
        write_Settings_AnalogLabels();
    }
    else
    {
        read_Settings_Analog();
        read_Settings_AnalogLabels();
    }

    Settings_ID = 3;
}

// Config der Analogwert-Anzeige (Plotter / CVS)
void cSettings::write_Settings_Analog(int ID)
{
    QString Hardware = HardwareType[ID];

    QSettings Setting("KeyOz-Net", "QMK-Groundstation");

    Setting.beginGroup("Analog-Werte");
        Setting.setValue(Hardware + "-LogView",  QBitArray(Analog1.LogView));
        Setting.setValue(Hardware + "-PlotView", QBitArray(Analog1.PlotView));
    Setting.endGroup();
}

void cSettings::read_Settings_Analog(int ID)
{
    QBitArray Def_View;
    Def_View.fill(true,MaxAnalog);

    QString Hardware = HardwareType[ID];

    QSettings Setting("KeyOz-Net", "QMK-Groundstation");

    Setting.beginGroup("Analog-Werte");
        Analog1.LogView  = Setting.value(Hardware + "-LogView", QBitArray(Def_View)).value<QBitArray>();
        Analog1.PlotView = Setting.value(Hardware + "-PlotView", QBitArray(Def_View)).value<QBitArray>();
    Setting.endGroup();
}

// Labels der Analogwerte.
void cSettings::write_Settings_AnalogLabels(int ID)
{
    QString Hardware = HardwareType[ID];

    QSettings Setting("KeyOz-Net", "QMK-Groundstation-Labels");

    Setting.beginGroup("Analog-Labels-" + Hardware);
        Setting.setValue("Version", Analog1.Version);
        for (int a=0; a<MaxAnalog; a++)
        {
            Setting.setValue("Label_" + QString("%1").arg(a), Analog1.Label[a]);
        }
    Setting.endGroup();
}

void cSettings::read_Settings_AnalogLabels(int ID)
{
    QString Hardware = HardwareType[ID];

    QSettings Setting("KeyOz-Net", "QMK-Groundstation-Labels");

    Setting.beginGroup("Analog-Labels-" + Hardware);
        Analog1.Version  = Setting.value(("Version"), "0").toString();
        for (int a=0; a<MaxAnalog; a++)
        {
            Analog1.Label[a]  = Setting.value(("Label_" + QString("%1").arg(a)), Def_AnalogNames[a]).toString();
        }
    Setting.endGroup();
}

// Programmeinstellungen
void cSettings::read_SettingsID()
{
    QSettings Setting("KeyOz-Net", "QMK-Groundstation");

    Setting.beginGroup("Global");
        Settings_ID  = Setting.value("Settings ID", 1).toInt();
    Setting.endGroup();
}

// Programmeinstellungen
void cSettings::read_Settings()
{
    QBitArray Def_BitArray;
    Def_BitArray.fill(true, 10);

    QDir Dir;

    QString HomeDir = (QString(Dir.homePath() + "/"));

    QSettings Setting("KeyOz-Net", "QMK-Groundstation");

    Setting.beginGroup("Global");
        Settings_ID  = Setting.value("Settings ID", 1).toInt();
    Setting.endGroup();

    Setting.beginGroup("Port");
        TTY.Port     = Setting.value("TTY", QString(OS_PORT)).toString();
        TTY.MaxPorts = Setting.value("TTY_MAX", 1).toInt();
        TTY.PortID   = Setting.value("TTY_ID",  0).toInt();

        for (int z = 0; z < TTY.MaxPorts; z++)
        {
            TTY.Ports[z] = Setting.value("TTY_" + QString("%1").arg(z), QString(OS_PORT)).toString();
        }
    Setting.endGroup();

    Setting.beginGroup("GUI");
        GUI.isMax       = Setting.value("IsMax",false).toBool();
        GUI.Size        = Setting.value("Size", QSize(700, 300)).toSize();
        GUI.Point       = Setting.value("Point",QPoint(1,1)).toPoint();
        GUI.TabViews    = Setting.value("TabViews", QBitArray(Def_BitArray)).value<QBitArray>();
        GUI.ToolViews   = Setting.value("ToolViews", QBitArray(Def_BitArray)).value<QBitArray>();
        GUI.Term_Info   = Setting.value("Terminal_Info",false).toBool();
        GUI.Term_Data   = Setting.value("Terminal_Data",true).toBool();
        GUI.Term_Always = Setting.value("Terminal_Always",false).toBool();
        GUI.Term_Send   = Setting.value("Terminal_Send",true).toBool();
    Setting.endGroup();

    Setting.beginGroup("Map");
        Map.GotoPosition  = Setting.value("Goto_Position",true).toBool();
        Map.ShowTrack     = Setting.value("Show_Track",true).toBool();
        Map.LastLatitude  = Setting.value("Last_Latitude",13.5).toDouble();
        Map.LastLongitude = Setting.value("Last_Longitude",52.5).toDouble();
    Setting.endGroup();

    Setting.beginGroup("Dirs");
        DIR.Logging   = Setting.value("LogDir", HomeDir).toString();
        DIR.Parameter = Setting.value("ParDir", HomeDir).toString();
        DIR.Cache     = Setting.value("Dir_MapCache", HomeDir + ".QMK-Cache").toString();
        DIR.AVRDUDE   = Setting.value("Path_AVRDUDE", "avrdude").toString();
    Setting.endGroup();

    Setting.beginGroup("MKData");
        Data.Plotter_Count  = Setting.value("Plotter_Count", 100).toInt();
        Data.Debug_Fast     = Setting.value("Debug_Fast", 100).toInt();
        Data.Debug_Slow     = Setting.value("Debug_Slow", 500).toInt();
        Data.Debug_Off      = Setting.value("Debug_Off", 1000).toInt();
        Data.Navi_Fast      = Setting.value("Navi_Fast", 100).toInt();
        Data.Navi_Slow      = Setting.value("Navi_Slow", 500).toInt();
        Data.Navi_Off       = Setting.value("Navi_Off", 1000).toInt();
    Setting.endGroup();

    Setting.beginGroup("GoogleEarth-Server");
        Server.Port        = Setting.value("Port", 10664).toString();
        Server.StartServer = Setting.value("StartServer", false).toBool();
        Server.ToGround    = Setting.value("ToGround",  false).toBool();
    Setting.endGroup();

    Setting.beginGroup("QMK-Server");
        Server.QMKS_Login    = Setting.value("Login", "").toString();
        Server.QMKS_Password = Setting.value("Password", "").toString();
        Server.QMKS_Host     = Setting.value("Host", "nimari.de").toString();
        Server.QMKS_Port     = Setting.value("Port", "16441").toString();
    Setting.endGroup();

}

void cSettings::write_Settings()
{
    QSettings Setting("KeyOz-Net", "QMK-Groundstation");

    Setting.beginGroup("Global");
        Setting.setValue("Settings ID", Settings_ID);
    Setting.endGroup();

    Setting.beginGroup("Port");
        Setting.setValue("TTY", TTY.Port);
        Setting.setValue("TTY_MAX", TTY.MaxPorts);
        Setting.setValue("TTY_ID", TTY.PortID);

        for (int z = 0; z < TTY.MaxPorts; z++)
        {
            Setting.setValue("TTY_" + QString("%1").arg(z), TTY.Ports[z]);
        }
    Setting.endGroup();

    Setting.beginGroup("Dirs");
        Setting.setValue("LogDir", DIR.Logging);
        Setting.setValue("ParDir", DIR.Parameter);
        Setting.setValue("Dir_MapCache", DIR.Cache);
        Setting.setValue("Path_AVRDUDE", DIR.AVRDUDE);
    Setting.endGroup();

    Setting.beginGroup("GUI");
        Setting.setValue("IsMax", GUI.isMax);
        Setting.setValue("Size", GUI.Size);
        Setting.setValue("Point", GUI.Point);
        Setting.setValue("TabViews", QBitArray(GUI.TabViews));
        Setting.setValue("ToolViews", QBitArray(GUI.ToolViews));
        Setting.setValue("Terminal_Info", GUI.Term_Info);
        Setting.setValue("Terminal_Data", GUI.Term_Data);
        Setting.setValue("Terminal_Always", GUI.Term_Always);
        Setting.setValue("Terminal_Send", GUI.Term_Send);
    Setting.endGroup();

    Setting.beginGroup("Map");
        Setting.setValue("Goto_Position", Map.GotoPosition);
        Setting.setValue("Show_Track", Map.ShowTrack);
        Setting.setValue("Last_Latitude", Map.LastLatitude);
        Setting.setValue("Last_Longitude", Map.LastLongitude);

    Setting.endGroup();

    Setting.beginGroup("MKData");
        Setting.setValue("Plotter_Count", Data.Plotter_Count);
        Setting.setValue("Debug_Fast", Data.Debug_Fast);
        Setting.setValue("Debug_Slow", Data.Debug_Slow);
        Setting.setValue("Debug_Off",  Data.Debug_Off);
        Setting.setValue("Navi_Fast", Data.Navi_Fast);
        Setting.setValue("Navi_Slow", Data.Navi_Slow);
        Setting.setValue("Navi_Off",  Data.Navi_Off);
    Setting.endGroup();

    Setting.beginGroup("GoogleEarth-Server");
        Setting.setValue("Port", Server.Port);
        Setting.setValue("StartServer", Server.StartServer);
        Setting.setValue("ToGround",  Server.ToGround);
    Setting.endGroup();

    Setting.beginGroup("QMK-Server");
        Setting.setValue("Login", Server.QMKS_Login);
        Setting.setValue("Password", Server.QMKS_Password);
        Setting.setValue("Host", Server.QMKS_Host);
        Setting.setValue("Port", Server.QMKS_Port);
    Setting.endGroup();
}

cSettings::~cSettings()
{
}


